//
//  RSViewController.m
//  RSKit Example
//
//  Created by Max Lansing on 1/29/14.
//  Copyright (c) 2014 Retention Science. All rights reserved.
//

#import "RSViewController.h"
#import <RSKit/RSKit.h>

@interface RSViewController ()

@end

static NSString *GenerateUUIDString() {
    CFUUIDRef theUUID = CFUUIDCreate(NULL);
    NSString *UUIDString = (__bridge_transfer NSString *)CFUUIDCreateString(NULL, theUUID);
    CFRelease(theUUID);
    return UUIDString;
}

@implementation RSViewController

- (void)viewDidLoad
{
    
    self.view.backgroundColor = [UIColor whiteColor];
    
    UIButton * trackButton1 = [UIButton buttonWithType:UIButtonTypeRoundedRect];
    trackButton1.frame = CGRectMake(60, 20, 200, 40);
    trackButton1.titleLabel.font = [UIFont fontWithName:@"ChalkboardSE-Bold" size:14];
    [trackButton1 setTitle:@"Track view" forState:UIControlStateNormal];
    [trackButton1 addTarget:self action:@selector(track1) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:trackButton1];
    
    UIButton * trackButton2 = [UIButton buttonWithType:UIButtonTypeRoundedRect];
    trackButton2.frame = CGRectMake(60, 80, 200, 40);
    trackButton2.titleLabel.font = [UIFont fontWithName:@"ChalkboardSE-Bold" size:14];
    [trackButton2 setTitle:@"Track shopping_cart" forState:UIControlStateNormal];
    [trackButton2 addTarget:self action:@selector(track2) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:trackButton2];
    
    UIButton * trackButton3 = [UIButton buttonWithType:UIButtonTypeRoundedRect];
    trackButton3.frame = CGRectMake(60, 140, 200, 40);
    trackButton3.titleLabel.font = [UIFont fontWithName:@"ChalkboardSE-Bold" size:14];
    [trackButton3 setTitle:@"Track checkout_success" forState:UIControlStateNormal];
    [trackButton3 addTarget:self action:@selector(track3) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:trackButton3];

    UIButton * sessionButton = [UIButton buttonWithType:UIButtonTypeRoundedRect];
    sessionButton.frame = CGRectMake(60, 212, 200, 40);
    sessionButton.titleLabel.font = [UIFont fontWithName:@"Zapfino" size:14];
    [sessionButton setTitle:@"Refresh Session ID" forState:UIControlStateNormal];
    [sessionButton addTarget:self action:@selector(doSession) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:sessionButton];
    
    UIButton * startLocationButton = [UIButton buttonWithType:UIButtonTypeRoundedRect];
    startLocationButton.frame = CGRectMake(60, 270, 200, 40);
    startLocationButton.titleLabel.font = [UIFont fontWithName:@"AmericanTypewriter" size:18];
    [startLocationButton setTitle:@"Start Location Updates" forState:UIControlStateNormal];
    [startLocationButton addTarget:self action:@selector(startLocation) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:startLocationButton];
    
    UIButton * stopLocationButton = [UIButton buttonWithType:UIButtonTypeRoundedRect];
    stopLocationButton.frame = CGRectMake(60, 330, 200, 40);
    stopLocationButton.titleLabel.font = [UIFont fontWithName:@"AmericanTypewriter" size:18];
    [stopLocationButton setTitle:@"Stop Location Updates" forState:UIControlStateNormal];
    [stopLocationButton addTarget:self action:@selector(stopLocation) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:stopLocationButton];
    
    [super viewDidLoad];

    _price = @1.50;
}

- (void)track1 {
    [self track:@"view" properties:@{@"customProperty": @"test"}];
    _price = [NSNumber numberWithFloat:_price.floatValue + 1];
}

- (void)track2 {
    [self track:@"shopping_cart" properties:@{@"items": @[@{@"id": @"123", @"name": @"Bike helmet", @"price": _price}]}];
    _price = [NSNumber numberWithFloat:_price.floatValue + 1];
}

- (void)track3 {
    [self track:@"checkout_success" properties:@{@"order_total": _price, @"order_id": @"333", @"items": @[@{@"id": @"123", @"name": @"bike", @"price": _price}]}];
    _price = [NSNumber numberWithFloat:_price.floatValue + 1];
}

- (void)doSession {
    [[RSClient sharedClient] setSessionId:GenerateUUIDString() expiresIn:10];
}

- (void)startLocation {
    if (!_locationManager) {
        _locationManager = [[CLLocationManager alloc] init];
        _locationManager.delegate = self;
    }
    
    [_locationManager startUpdatingLocation];
    [RSClient sharedClient].locationManager = _locationManager;
}

- (void)stopLocation {
    [_locationManager stopUpdatingLocation];
    [RSClient sharedClient].locationManager = nil;
}

-(void)track:(NSString*)action properties:(NSDictionary *)properties {
    [[RSClient sharedClient] track:action properties:properties];
}

-(void)locationManager:(CLLocationManager *)manager didUpdateLocations:(NSArray *)locations {
//    NSLog(@"location update! %@", [locations.firstObject description]);
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

@end
